/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.StreamInfo;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;

public class OracleTypeTIMESTAMP
extends OracleType
implements Serializable {
    static final long serialVersionUID = 3948043338303602796L;
    int prec = 0;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    protected OracleTypeTIMESTAMP() {
    }

    public OracleTypeTIMESTAMP(OracleConnection oracleConnection) {
    }

    public int getTypeCode() {
        return 93;
    }

    public void parseTDSrec(StreamInfo streamInfo) throws SQLException {
        this.prec = streamInfo.readByte();
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public int getPrecision() throws SQLException {
        return this.prec;
    }

    public void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.prec = objectInputStream.readByte();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeByte(this.prec);
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        switch (n) {
            case 1: {
                return new TIMESTAMP(byArray);
            }
            case 2: {
                return TIMESTAMP.toTimestamp(byArray);
            }
            case 3: {
                return byArray;
            }
        }
        DatabaseError.check_error(59);
        return null;
    }

    public Datum toDatum(Object object, OracleConnection oracleConnection) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (object != null) {
            try {
                if (object instanceof TIMESTAMP) {
                    tIMESTAMP = (TIMESTAMP)object;
                } else if (object instanceof byte[]) {
                    tIMESTAMP = new TIMESTAMP((byte[])object);
                } else if (object instanceof Timestamp) {
                    tIMESTAMP = new TIMESTAMP((Timestamp)object);
                } else if (object instanceof DATE) {
                    tIMESTAMP = new TIMESTAMP((DATE)object);
                } else if (object instanceof String) {
                    tIMESTAMP = new TIMESTAMP((String)object);
                } else if (object instanceof Date) {
                    tIMESTAMP = new TIMESTAMP((Date)object);
                } else if (object instanceof Time) {
                    tIMESTAMP = new TIMESTAMP((Time)object);
                } else {
                    DatabaseError.check_error(59, object);
                }
            }
            catch (Exception exception) {
                DatabaseError.check_error(59, object);
            }
        }
        return tIMESTAMP;
    }

    protected Object unpickle80rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }

    protected Object unpickle81rec(UnpickleContext unpickleContext, int n, int n2, Map map) throws SQLException {
        DatabaseError.throwSqlException(90);
        return null;
    }
}

