/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.PickleOutputStream;

public final class PickleContext {
    private PickleOutputStream stream_pctx;
    byte[] m_image;
    int m_offset;
    private byte[] lenbuf_pctx = new byte[5];
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public PickleContext() {
    }

    public PickleContext(byte[] byArray) {
        this.m_image = byArray;
        this.m_offset = 0;
    }

    public PickleContext(byte[] byArray, long l) {
        this.m_image = byArray;
        this.m_offset = (int)l;
    }

    public void initStream_pctx(int n) {
        this.stream_pctx = new PickleOutputStream(n);
    }

    public void initStream_pctx() {
        this.stream_pctx = new PickleOutputStream();
    }

    public int lenbytes_pctx(int n) {
        return n <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int writeEltNull_pctx() throws SQLException {
        this.stream_pctx.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull_pctx() throws SQLException {
        this.stream_pctx.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeIEmbNull_pctx(byte by) throws SQLException {
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_IEMN;
        this.lenbuf_pctx[1] = by;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return 2;
    }

    public int writeLength_pctx(int n) throws SQLException {
        if (n <= KOPI20_LN_MAXV) {
            this.stream_pctx.write((byte)n);
            return 1;
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)(n >> 24);
        this.lenbuf_pctx[2] = (byte)((n &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((n &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(n &= 0xFF);
        try {
            this.stream_pctx.write(this.lenbuf_pctx);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return 5;
    }

    public int writeLength_pctx(int n, boolean bl) throws SQLException {
        if (!bl) {
            return this.writeLength_pctx(n);
        }
        if (n <= KOPI20_LN_MAXV - 1) {
            this.stream_pctx.write((byte)n + 1);
            return 1;
        }
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)((n += 5) >> 24);
        this.lenbuf_pctx[2] = (byte)((n &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((n &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(n &= 0xFF);
        try {
            this.stream_pctx.write(this.lenbuf_pctx);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return 5;
    }

    public byte[] to5bLengthBytes_pctx(int n) throws SQLException {
        this.lenbuf_pctx[0] = (byte)KOPI20_LN_5BLN;
        this.lenbuf_pctx[1] = (byte)(n >> 24);
        this.lenbuf_pctx[2] = (byte)((n &= 0xFFFFFF) >> 16);
        this.lenbuf_pctx[3] = (byte)((n &= 0xFFFF) >> 8);
        this.lenbuf_pctx[4] = (byte)(n &= 0xFF);
        return this.lenbuf_pctx;
    }

    public int write_data_pctx(byte by) throws SQLException {
        this.stream_pctx.write(by);
        return 1;
    }

    public int write_data_pctx(byte[] byArray) throws SQLException {
        try {
            this.stream_pctx.write(byArray);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return byArray.length;
    }

    public void patchImageLen_pctx(int n, int n2) throws SQLException {
        byte[] byArray = this.to5bLengthBytes_pctx(n2);
        this.stream_pctx.overwrite(n, byArray, 0, byArray.length);
    }

    public int writeImageHeader_pctx(boolean bl) throws SQLException {
        return this.writeImageHeader_pctx(KOPI20_LN_MAXV + 1, bl);
    }

    public int writeOpaqueImageHeader_pctx(int n) throws SQLException {
        int n2 = 2;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return n2 += this.writeLength_pctx(n + 2, true);
    }

    public int writeImageHeader_pctx(int n, boolean bl) throws SQLException {
        int n2 = 2;
        this.lenbuf_pctx[0] = bl ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        return n2 += this.writeLength_pctx(n);
    }

    public int writeCollImageHeader_pctx(int n) throws SQLException {
        return this.writeCollImageHeader_pctx(KOPI20_LN_MAXV + 1, n);
    }

    public int writeCollImageHeader_pctx(int n, int n2) throws SQLException {
        int n3 = 5;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        n3 += this.writeLength_pctx(n);
        this.lenbuf_pctx[0] = 1;
        this.lenbuf_pctx[1] = 1;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        return n3 += this.writeLength_pctx(n2);
    }

    public int writeCollImageHeader_pctx(byte[] byArray) throws SQLException {
        return this.writeCollImageHeader_pctx(KOPI20_LN_MAXV + 1, byArray);
    }

    public int writeCollImageHeader_pctx(int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        int n3 = 3 + n2;
        this.lenbuf_pctx[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.lenbuf_pctx[1] = (byte)KOPI20_VERSION;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 2);
        n3 += this.writeLength_pctx(n);
        this.lenbuf_pctx[0] = 0;
        this.stream_pctx.write(this.lenbuf_pctx, 0, 1);
        this.stream_pctx.write(byArray, 0, n2);
        return n3 += this.writeLength_pctx(n2 + 1);
    }

    public byte[] stream2bytes_pctx() throws SQLException {
        return this.stream_pctx.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte_pctx() throws SQLException {
        try {
            byte by = this.m_image[this.m_offset];
            return by;
        }
        finally {
            ++this.m_offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndCheckVersion_pctx() throws SQLException {
        try {
            boolean bl = (this.m_image[this.m_offset] & 0xFF) <= KOPI20_VERSION;
            return bl;
        }
        finally {
            ++this.m_offset;
        }
    }

    public int readLength_pctx() throws SQLException {
        int n = this.m_image[this.m_offset] & 0xFF;
        if (n > KOPI20_LN_MAXV) {
            if (n == KOPI20_LN_ELNL) {
                DatabaseError.throwSqlException(1, "Invalid null flag read");
            }
            n = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            this.m_offset += 5;
        } else {
            ++this.m_offset;
        }
        return n;
    }

    public void skipLength_pctx() throws SQLException {
        int n = this.m_image[this.m_offset] & 0xFF;
        this.m_offset = n > KOPI20_LN_MAXV ? (this.m_offset += 5) : ++this.m_offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readRestOfLength_pctx(byte by) throws SQLException {
        if ((by & 0xFF) != KOPI20_LN_5BLN) {
            return by & 0xFF;
        }
        try {
            int n = (((this.m_image[this.m_offset] & 0xFF) * 256 + (this.m_image[this.m_offset + 1] & 0xFF)) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF);
            return n;
        }
        finally {
            this.m_offset += 4;
        }
    }

    public void skipRestOfLength_pctx(byte by) throws SQLException {
        if ((by & 0xFF) > KOPI20_LN_MAXV) {
            if ((by & 0xFF) == KOPI20_LN_5BLN) {
                this.m_offset += 4;
            } else {
                DatabaseError.throwSqlException(1, "Invalid first length byte");
            }
        }
    }

    public int readLength_pctx(boolean bl) throws SQLException {
        int n = this.m_image[this.m_offset] & 0xFF;
        if (n > KOPI20_LN_MAXV) {
            n = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            if (bl) {
                n -= 5;
            }
            this.m_offset += 5;
        } else {
            if (bl) {
                --n;
            }
            ++this.m_offset;
        }
        return n;
    }

    public byte[] readPrefixSegment_pctx() throws SQLException {
        byte[] byArray = new byte[this.readLength_pctx()];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue_pctx() throws SQLException {
        int n = this.m_image[this.m_offset] & 0xFF;
        if (n == KOPI20_LN_ELNL) {
            ++this.m_offset;
            return null;
        }
        if (n > KOPI20_LN_MAXV) {
            n = (((this.m_image[this.m_offset + 1] & 0xFF) * 256 + (this.m_image[this.m_offset + 2] & 0xFF)) * 256 + (this.m_image[this.m_offset + 3] & 0xFF)) * 256 + (this.m_image[this.m_offset + 4] & 0xFF);
            this.m_offset += 5;
        } else {
            ++this.m_offset;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public byte[] readBytes_pctx(int n) throws SQLException {
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, n);
        this.m_offset += n;
        return byArray;
    }

    public byte[] read1byteDataValue_pctx() throws SQLException {
        if ((this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] byArray = new byte[this.m_image[this.m_offset] & 0xFF];
        System.arraycopy(this.m_image, this.m_offset + 1, byArray, 0, byArray.length);
        this.m_offset += byArray.length + 1;
        return byArray;
    }

    public byte[] readDataValue_pctx(byte by) throws SQLException {
        byte[] byArray = new byte[this.readRestOfLength_pctx(by)];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, byArray.length);
        this.m_offset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue_pctx(int n) throws SQLException {
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_image, this.m_offset, byArray, 0, n);
        this.m_offset += n;
        return byArray;
    }

    public void skipDataValue_pctx() throws SQLException {
        if ((this.m_image[this.m_offset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.m_offset;
        } else {
            this.skip_bytes(this.readLength_pctx());
        }
    }

    public void skipDataValue_pctx(byte by) throws SQLException {
        this.skip_bytes(this.readRestOfLength_pctx(by));
    }

    public void skip_bytes(int n) throws SQLException {
        if (n > 0) {
            this.m_offset += n;
        }
    }

    public int offset() throws SQLException {
        if (this.stream_pctx != null) {
            return this.stream_pctx.offset();
        }
        return this.m_offset;
    }

    public int absolute_offset() throws SQLException {
        return this.m_offset;
    }

    public void skip_to(long l) throws SQLException {
        if (l > (long)this.m_offset) {
            this.m_offset = (int)l;
        }
    }

    public byte[] image() throws SQLException {
        return this.m_image;
    }

    public static boolean is81format_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isCollectionImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean hasPrefix_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public static boolean isAtomicNull_pctx(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isImmEmbNull_pctx(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_IEMN;
    }

    public static boolean isElementNull_pctx(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ELNL;
    }
}

