/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.Datum;

public class LobPlsqlUtil {
    static boolean PLSQL_DEBUG = false;
    static final int MAX_PLSQL_SIZE = 32512;
    static final int MAX_PLSQL_INSTR_SIZE = 32512;
    static final int MAX_CHUNK_SIZE = 32512;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "050209";

    public static long plsql_read(BLOB bLOB, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bLOB.getInternalConnection(), bLOB, 2004, l, l2, byArray);
    }

    public static long plsql_length(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(bLOB.getInternalConnection(), bLOB, 2004);
    }

    public static long plsql_hasPattern(BLOB bLOB, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bLOB.getInternalConnection(), bLOB, 2004, byArray, l);
    }

    public static long plsql_isSubLob(BLOB bLOB, BLOB bLOB2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bLOB.getInternalConnection(), bLOB, 2004, bLOB2, l);
    }

    public static long plsql_getChunkSize(BLOB bLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(bLOB.getInternalConnection(), bLOB, 2004);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_read(CLOB cLOB, long l, long l2, char[] cArray) throws SQLException {
        Statement statement = null;
        int n = 0;
        int n2 = 1;
        try {
            try {
                Object var9_7 = null;
                boolean bl = false;
                OracleConnection oracleConnection = cLOB.getInternalConnection();
                boolean bl2 = oracleConnection.isCharSetMultibyte(oracleConnection.getDriverCharSet());
                if (bl2) {
                    n2 = oracleConnection.getMaxCharSize();
                }
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read(:1, :2, :3, :4); end;");
                int n3 = 0;
                int n4 = 0;
                byte[] byArray = null;
                char[] cArray2 = new char[32512];
                if (cLOB.isNCLOB()) {
                    statement.setFormOfUse(1, (short)2);
                    statement.setFormOfUse(4, (short)2);
                    if (oracleConnection.IsNCharFixedWith()) {
                        n2 = 2;
                    }
                }
                statement.setCLOB(1, cLOB);
                statement.registerOutParameter(2, 2);
                statement.registerOutParameter(4, 12);
                while ((long)n < l2) {
                    n4 = (int)Math.min(l2 - (long)n, (long)(32512 / n2));
                    statement.setInt(2, n4);
                    statement.setLong(3, l + (long)n);
                    statement.execute();
                    n3 = statement.getInt(2);
                    byArray = statement.getBytes(4);
                    int n5 = 0;
                    n5 = cLOB.isNCLOB() ? oracleConnection.NCHARBytesToJavaChars(byArray, byArray.length, cArray2) : oracleConnection.CHARBytesToJavaChars(byArray, byArray.length, cArray2);
                    if (n5 != n3) {
                        DatabaseError.check_error(37, null);
                    }
                    System.arraycopy(cArray2, 0, cArray, n, n3);
                    n += n3;
                }
                Object var19_17 = null;
                if (statement == null) return n;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1403) {
                    throw sQLException;
                }
                Object var19_18 = null;
                if (statement == null) return n;
                statement.close();
                return n;
            }
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            if (statement != null) {
                statement.close();
                statement = null;
            }
            throw throwable;
        }
        statement.close();
        return n;
    }

    public static long plsql_length(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_length(cLOB.getInternalConnection(), cLOB, 2005);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long plsql_hasPattern(CLOB cLOB, char[] cArray, long l) throws SQLException {
        if (cArray == null || l <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getInternalConnection();
        long l2 = cArray.length;
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB, 2005);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            Statement statement = null;
            try {
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                statement.registerOutParameter(1, 2);
                if (cLOB.isNCLOB()) {
                    statement.setFormOfUse(2, (short)2);
                    statement.setFormOfUse(3, (short)2);
                }
                statement.setCLOB(2, cLOB);
                statement.setString(3, new String(cArray));
                statement.setLong(4, l);
                statement.execute();
                long l4 = statement.getLong(1);
                return l4;
            }
            finally {
                statement.close();
                statement = null;
            }
        }
        int n = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
            char[] cArray2 = new char[n2];
            System.arraycopy(cArray, n, cArray2, 0, n2);
            long l7 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n += n2;
            l5 = l7 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
                cArray2 = new char[n2];
                System.arraycopy(cArray, n, cArray2, 0, n2);
                l7 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n;
                bl2 = false;
            }
        }
        return l6;
    }

    public static long plsql_isSubLob(CLOB cLOB, CLOB cLOB2, long l) throws SQLException {
        if (cLOB2 == null || l <= 0L) {
            return 0L;
        }
        OracleConnection oracleConnection = cLOB.getInternalConnection();
        long l2 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB2, 2005);
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, cLOB, 2005);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= (long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection)) {
            char[] cArray = new char[(int)l2];
            cLOB2.getChars(1L, (int)l2, cArray);
            return LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l);
        }
        int n = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n = 0;
            int n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
            char[] cArray = new char[n2];
            cLOB2.getChars(n + 1, n2, cArray);
            long l6 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n += n2;
            l4 = l6 + (long)n2;
            boolean bl2 = true;
            while (bl2) {
                n2 = (int)Math.min((long)LobPlsqlUtil.getPlsqlMaxInstrSize(oracleConnection), l2 - (long)n);
                cArray = new char[n2];
                cLOB2.getChars(n + 1, n2, cArray);
                l6 = LobPlsqlUtil.plsql_hasPattern(cLOB, cArray, l4);
                if (l6 == l4) {
                    l4 += (long)n2;
                    if ((long)(n += n2) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n;
                bl2 = false;
            }
        }
        return l5;
    }

    public static long plsql_getChunkSize(CLOB cLOB) throws SQLException {
        return LobPlsqlUtil.plsql_getChunkSize(cLOB.getInternalConnection(), cLOB, 2005);
    }

    public static long plsql_read(BFILE bFILE, long l, long l2, byte[] byArray) throws SQLException {
        return LobPlsqlUtil.plsql_read(bFILE.getInternalConnection(), bFILE, -13, l, l2, byArray);
    }

    public static long plsql_length(BFILE bFILE) throws SQLException {
        return LobPlsqlUtil.plsql_length(bFILE.getInternalConnection(), bFILE, -13);
    }

    public static long plsql_hasPattern(BFILE bFILE, byte[] byArray, long l) throws SQLException {
        return LobPlsqlUtil.plsql_hasPattern(bFILE.getInternalConnection(), bFILE, -13, byArray, l);
    }

    public static long plsql_isSubLob(BFILE bFILE, BFILE bFILE2, long l) throws SQLException {
        return LobPlsqlUtil.plsql_isSubLob(bFILE.getInternalConnection(), bFILE, -13, bFILE2, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_fileOpen(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin dbms_lob.fileopen (:1, :2); end;");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.setInt(2, 0);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
            Object var3_2 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_fileIsOpen(BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin :1 := dbms_lob.fileIsOpen(:2); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_fileExists(BFILE bFILE) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin :1 := dbms_lob.fileExists(:2); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.setBFILE(2, bFILE);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String plsql_fileGetName(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(3);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String plsql_fileGetDirAlias(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        String string = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(2, 12);
            oracleCallableStatement.registerOutParameter(3, 12);
            oracleCallableStatement.execute();
            string = oracleCallableStatement.getString(2);
            Object var4_3 = null;
            if (oracleCallableStatement == null) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_fileClose(BFILE bFILE) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)bFILE.getInternalConnection().prepareCall("begin dbms_lob.fileclose (:1); end;");
            oracleCallableStatement.setBFILE(1, bFILE);
            oracleCallableStatement.registerOutParameter(1, -13);
            oracleCallableStatement.execute();
            bFILE.setLocator(oracleCallableStatement.getBFILE(1).getLocator());
            Object var3_2 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    private static int getPlsqlMaxInstrSize(OracleConnection oracleConnection) throws SQLException {
        boolean bl = oracleConnection.isCharSetMultibyte(oracleConnection.getDriverCharSet());
        int n = oracleConnection.getMaxCharbyteSize();
        int n2 = 32512;
        if (bl) {
            n2 = 32512 / (oracleConnection.getC2SNlsRatio() * n);
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_read(OracleConnection oracleConnection, Datum datum, int n, long l, long l2, byte[] byArray) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        int n2 = 0;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin dbms_lob.read (:1, :2, :3, :4); end;");
                int n3 = 0;
                int n4 = 0;
                if (LobPlsqlUtil.isNCLOB(datum)) {
                    oracleCallableStatement.setFormOfUse(1, (short)2);
                    oracleCallableStatement.setFormOfUse(4, (short)2);
                }
                oracleCallableStatement.setObject(1, (Object)datum, n);
                oracleCallableStatement.registerOutParameter(2, 2);
                oracleCallableStatement.registerOutParameter(4, -3);
                while ((long)n2 < l2) {
                    n4 = Math.min((int)l2, 32512);
                    oracleCallableStatement.setInt(2, n4);
                    oracleCallableStatement.setInt(3, (int)l + n2);
                    oracleCallableStatement.execute();
                    n3 = oracleCallableStatement.getInt(2);
                    byte[] byArray2 = oracleCallableStatement.getBytes(4);
                    System.arraycopy(byArray2, 0, byArray, n2, n3);
                    n2 += n3;
                    l2 -= (long)n3;
                }
                Object var14_12 = null;
                if (oracleCallableStatement == null) return n2;
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 1403) {
                    throw sQLException;
                }
                Object var14_13 = null;
                if (oracleCallableStatement == null) return n2;
                oracleCallableStatement.close();
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static long plsql_length(OracleConnection oracleConnection, Datum datum, int n) throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.getLength (:2); end;");
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setObject(2, (Object)datum, n);
            oracleCallableStatement.registerOutParameter(1, 2);
            oracleCallableStatement.execute();
            l = oracleCallableStatement.getLong(1);
            Object var7_5 = null;
            if (oracleCallableStatement == null) return l;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long plsql_hasPattern(OracleConnection oracleConnection, Datum datum, int n, byte[] byArray, long l) throws SQLException {
        if (byArray == null || l <= 0L) {
            return 0L;
        }
        long l2 = byArray.length;
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, datum, n);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            Statement statement = null;
            try {
                statement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
                statement.registerOutParameter(1, 2);
                statement.setObject(2, datum, n);
                statement.setBytes(3, byArray);
                statement.setLong(4, l);
                statement.execute();
                long l4 = statement.getLong(1);
                return l4;
            }
            finally {
                statement.close();
                statement = null;
            }
        }
        int n2 = 0;
        long l5 = l;
        boolean bl = false;
        long l6 = 0L;
        while (!bl) {
            if (l2 > l3 - l5 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min(32512L, l2 - (long)n2);
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2, byArray2, 0, n3);
            long l7 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray2, l5);
            if (l7 == 0L) {
                return 0L;
            }
            l6 = l7;
            n2 += n3;
            l5 = l7 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min(32512L, l2 - (long)n2);
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
                l7 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray2, l5);
                if (l7 == l5) {
                    l5 += (long)n3;
                    if ((long)(n2 += n3) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l7 == 0L) {
                    return 0L;
                }
                l5 = l7 - (long)n2;
                bl2 = false;
            }
        }
        return l6;
    }

    public static long plsql_isSubLob(OracleConnection oracleConnection, Datum datum, int n, Datum datum2, long l) throws SQLException {
        if (datum2 == null || l <= 0L) {
            return 0L;
        }
        long l2 = LobPlsqlUtil.plsql_length(oracleConnection, datum2, n);
        long l3 = LobPlsqlUtil.plsql_length(oracleConnection, datum, n);
        if (l2 == 0L || l2 > l3 - l + 1L || l > l3) {
            return 0L;
        }
        if (l2 <= 32512L) {
            byte[] byArray = new byte[(int)l2];
            LobPlsqlUtil.plsql_read(oracleConnection, datum2, n, 1L, l2, byArray);
            return LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray, l);
        }
        int n2 = 0;
        long l4 = l;
        boolean bl = false;
        long l5 = 0L;
        while (!bl) {
            if (l2 > l3 - l4 + 1L) {
                return 0L;
            }
            n2 = 0;
            int n3 = (int)Math.min(32512L, l2 - (long)n2);
            byte[] byArray = new byte[n3];
            LobPlsqlUtil.plsql_read(oracleConnection, datum2, n, n2 + 1, n3, byArray);
            long l6 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray, l4);
            if (l6 == 0L) {
                return 0L;
            }
            l5 = l6;
            n2 += n3;
            l4 = l6 + (long)n3;
            boolean bl2 = true;
            while (bl2) {
                n3 = (int)Math.min(32512L, l2 - (long)n2);
                byArray = new byte[n3];
                LobPlsqlUtil.plsql_read(oracleConnection, datum2, n, n2 + 1, n3, byArray);
                l6 = LobPlsqlUtil.plsql_hasPattern(oracleConnection, datum, n, byArray, l4);
                if (l6 == l4) {
                    l4 += (long)n3;
                    if ((long)(n2 += n3) != l2) continue;
                    bl2 = false;
                    bl = true;
                    continue;
                }
                if (l6 == 0L) {
                    return 0L;
                }
                l4 = l6 - (long)n2;
                bl2 = false;
            }
        }
        return l5;
    }

    private static boolean isNCLOB(Datum datum) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("oracle.sql.CLOB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        if (!clazz.isInstance(datum)) {
            return false;
        }
        CLOB cLOB = (CLOB)datum;
        return cLOB.isNCLOB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long plsql_getChunkSize(OracleConnection oracleConnection, Datum datum, int n) throws SQLException {
        long l = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            try {
                oracleCallableStatement = (OracleCallableStatement)oracleConnection.prepareCall("begin :1 := dbms_lob.getchunksize(:2); end;");
                oracleCallableStatement.registerOutParameter(1, 2);
                if (LobPlsqlUtil.isNCLOB(datum)) {
                    oracleCallableStatement.setFormOfUse(2, (short)2);
                }
                oracleCallableStatement.setObject(2, (Object)datum, n);
                oracleCallableStatement.execute();
                l = oracleCallableStatement.getLong(1);
            }
            catch (SQLException sQLException) {
                if (sQLException.getErrorCode() != 6550) {
                    throw sQLException;
                }
                l = 32512L;
                Object var8_6 = null;
                if (oracleCallableStatement == null) return l;
                oracleCallableStatement.close();
                return l;
            }
            Object var8_5 = null;
            if (oracleCallableStatement == null) return l;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (oracleCallableStatement != null) {
                oracleCallableStatement.close();
                oracleCallableStatement = null;
            }
            throw throwable;
        }
        oracleCallableStatement.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_trimLob(Connection connection, Datum datum, int n, long l) throws SQLException {
        long l2 = 0L;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.trim (:1, :2); end;");
            oracleCallableStatement.registerOutParameter(1, n);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setObject(1, (Object)datum, n);
            oracleCallableStatement.setLong(2, l);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getBytes(1));
            Object var9_6 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Datum plsql_createTemporaryLob(Connection connection, boolean bl, int n, int n2, short s) throws SQLException {
        Statement statement = null;
        Datum datum = null;
        try {
            statement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.createTemporary (:1," + (bl ? "TRUE" : "FALSE") + ", :2); end;");
            statement.registerOutParameter(1, n2);
            statement.setFormOfUse(1, s);
            statement.setInt(2, n);
            statement.execute();
            datum = statement.getOracleObject(1);
            Object var8_7 = null;
            if (statement == null) return datum;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (statement == null) throw throwable;
            statement.close();
            statement = null;
            throw throwable;
        }
        statement.close();
        return datum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_freeTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.freeTemporary (:1); end;");
            oracleCallableStatement.registerOutParameter(1, n);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getBytes(1));
            Object var5_4 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_isTemporaryLob(Connection connection, Datum datum, int n) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin :1 := dbms_lob.isTemporary (:2); end;");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setOracleObject(2, datum);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var6_5 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_openLob(Connection connection, Datum datum, int n, int n2) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.open (:1, :2); end;");
            oracleCallableStatement.registerOutParameter(1, n2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.setInt(2, n);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getOracleObject(1).shareBytes());
            Object var6_5 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void plsql_closeLob(Connection connection, Datum datum, int n) throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin dbms_lob.close (:1); end;");
            oracleCallableStatement.registerOutParameter(1, n);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(1, (short)2);
            }
            oracleCallableStatement.setOracleObject(1, datum);
            oracleCallableStatement.execute();
            datum.setShareBytes(oracleCallableStatement.getOracleObject(1).shareBytes());
            Object var5_4 = null;
            if (oracleCallableStatement == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean plsql_isLobOpen(Connection connection, Datum datum, int n) throws SQLException {
        boolean bl;
        OracleCallableStatement oracleCallableStatement = null;
        try {
            oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("begin :1 := dbms_lob.isOpen(:2); end; ");
            oracleCallableStatement.registerOutParameter(1, 2);
            if (LobPlsqlUtil.isNCLOB(datum)) {
                oracleCallableStatement.setFormOfUse(2, (short)2);
            }
            oracleCallableStatement.setOracleObject(2, datum);
            oracleCallableStatement.execute();
            bl = oracleCallableStatement.getBoolean(1);
            Object var6_5 = null;
            if (oracleCallableStatement == null) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (oracleCallableStatement == null) throw throwable;
            oracleCallableStatement.close();
            oracleCallableStatement = null;
            throw throwable;
        }
        oracleCallableStatement.close();
        return bl;
    }
}

